/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.util;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.SchemaDoesNotExistException;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLUtilities {
    private static final String PureQueryParamMarker = ":";
    private static final String newLine = System.getProperty("line.separator");

    public static String generateSqlWithNoPQParamMarkers(String string) {
        int n2 = string.indexOf(PureQueryParamMarker);
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 >= 0) {
            stringBuilder.append(string.substring(n3, n2));
            stringBuilder.append(" ?");
            for (n3 = n2 + PureQueryParamMarker.length(); n3 < string.length() && string.charAt(n3) != ' ' && string.charAt(n3) != ')' && string.charAt(n3) != ','; ++n3) {
            }
            if (n3 < string.length()) {
                stringBuilder.append(' ');
            }
            n2 = string.indexOf(PureQueryParamMarker, n3);
        }
        if (n3 < string.length()) {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    public static List<String[]> runQuerySQL(Connection connection, String string, boolean bl2) throws MetadataException, SQLException {
        return SQLUtilities.runQuerySQL(connection, string, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> runQuerySQL(Connection connection, String string, boolean bl2, BlobContentHandler blobContentHandler) throws MetadataException, SQLException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n2;
            String[] stringArray;
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            int n4 = -1;
            int n5 = -1;
            if (bl2 || blobContentHandler != null) {
                stringArray = new String[n3];
                for (n2 = 1; n2 <= n3; ++n2) {
                    stringArray[n2 - 1] = resultSetMetaData.getColumnName(n2);
                    if (blobContentHandler != null && blobContentHandler.getBlobColumnName().equalsIgnoreCase(stringArray[n2 - 1])) {
                        n4 = n2;
                    }
                    if (blobContentHandler == null || blobContentHandler.getColumnName() == null || !blobContentHandler.getColumnName().equalsIgnoreCase(stringArray[n2 - 1])) continue;
                    n5 = n2;
                }
                if (bl2) {
                    arrayList.add(stringArray);
                }
            }
            while (resultSet.next()) {
                stringArray = new String[n3];
                for (n2 = 1; n2 <= n3; ++n2) {
                    if (n4 == n2) {
                        String string2 = null;
                        if (n5 > 0) {
                            string2 = resultSet.getString(n5);
                        }
                        InputStream inputStream = resultSet.getBinaryStream(n2);
                        stringArray[n2 - 1] = blobContentHandler.newBlobContent(string2, inputStream);
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    stringArray[n2 - 1] = resultSet.getString(n2);
                }
                arrayList.add(stringArray);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runUpdateSQL(Connection connection, String string) throws MetadataException, SQLException {
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        try {
            preparedStatement = connection.prepareStatement(string);
            n2 = preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Connection connection, String string, List<String> list, boolean bl2, List<Exception> list2, PrintWriter printWriter) throws IOException, SQLException, SchemaDoesNotExistException {
        Statement statement = null;
        String string2 = connection.getMetaData().getDatabaseProductName().toUpperCase();
        if (string != null && connection != null) {
            if (string2.contains("DB2") || string2.equals("AS") || string2.contains("DERBY")) {
                try {
                    block24: {
                        statement = connection.createStatement();
                        try {
                            statement.executeUpdate("create schema " + string);
                        }
                        catch (SQLException sQLException) {
                            String string3 = connection.getMetaData().getDatabaseProductVersion().toUpperCase();
                            if (!string3.startsWith("DSN08") && !string3.startsWith("DSN07") && !string3.matches("DSN09\\d\\d[0-4]") && !string3.matches("DSN10\\d\\d[0-1]")) break block24;
                            statement.execute("set current sqlid ='" + string + "'");
                        }
                    }
                    statement.executeUpdate("set current schema " + string);
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            if (string2.contains("ORACLE")) {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("alter session set current_schema=" + string);
                }
                catch (SQLException sQLException) {
                    String string4 = Messages.getText("ERR_ORA_SET_SCHEMA_IBMPDQ", new Object[]{PossibleArgs.REPOSITORY_SCHEMA, string});
                    throw new SchemaDoesNotExistException(string4, sQLException);
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }
        statement = connection.createStatement();
        try {
            boolean bl3 = false;
            for (int i10 = 0; i10 < list.size(); ++i10) {
                try {
                    statement.execute(list.get(i10));
                    continue;
                }
                catch (SQLException sQLException) {
                    if (!bl2) {
                        String string5 = sQLException.getMessage();
                        if (!string2.contains("DB2") || sQLException.getErrorCode() != -601 || !sQLException.getSQLState().equals("42710")) continue;
                        Logger logger = Log.getLogger();
                        boolean bl4 = logger != null && logger.isLoggable(Level.WARNING);
                        String string6 = string5 + ". ";
                        if (bl4) {
                            logger.logp(Level.WARNING, "SQLUtilities", "runScript", Messages.getText("MSG_CREATE_MULTIPLE_SCHEMAS", new Object[0]));
                            logger.logp(Level.WARNING, "SQLUtilities", "runScript", string6);
                        }
                        if (printWriter == null) continue;
                        if (!bl3) {
                            printWriter.append(Messages.getText("MSG_CREATE_MULTIPLE_SCHEMAS", new Object[0]));
                            bl3 = true;
                        }
                        printWriter.append(newLine);
                        printWriter.append(string6);
                        continue;
                    }
                    if (list2 == null) continue;
                    list2.add(sQLException);
                }
            }
        }
        finally {
            statement.close();
        }
    }

    public static String prepareIdentifierForSQLStatement(String string, String string2) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.length() > 1) {
            throw new RuntimeException("Cannot handle a database quote of length > 1.  Quote=" + string2);
        }
        stringBuilder.append(string2);
        for (char c10 : cArray = string.toCharArray()) {
            stringBuilder.append(c10);
            if (string2.charAt(0) != c10) continue;
            stringBuilder.append(c10);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static List<String> removeSQLComments(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            int n2 = string.indexOf("--");
            if (n2 >= 0) {
                String string2 = string.substring(0, n2);
                if (string2.trim().length() <= 0) continue;
                arrayList.add(string2);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Integer getIntegerFromNumber(Object object) {
        Integer n2 = null;
        if (object != null) {
            if (object instanceof Integer) {
                n2 = (Integer)object;
            } else if (object instanceof Number) {
                n2 = ((Number)object).intValue();
            }
        }
        return n2;
    }

    public static Timestamp getTimestampFromObject(Object object) {
        Timestamp timestamp = null;
        if (object != null) {
            if (object instanceof Timestamp) {
                timestamp = (Timestamp)object;
            } else if (object instanceof Date) {
                timestamp = new Timestamp(((Date)object).getTime());
            }
        }
        return timestamp;
    }

    public static interface BlobContentHandler {
        public String getColumnName();

        public String getBlobColumnName();

        public String newBlobContent(String var1, InputStream var2);
    }
}

