/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.stream.AbstractByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WrappedOutputStream
extends AbstractByteArrayOutputStream {
    private final OutputStream output;

    @Override
    protected void flushBuffer() throws IOException {
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public WrappedOutputStream(OutputStream stream, int bufferSize, Runnable postCloseAction) {
        super(ClickHouseUtils.getBufferSize(bufferSize, (Integer)ClickHouseClientOption.WRITE_BUFFER_SIZE.getDefaultValue(), (Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue()), postCloseAction);
        this.output = ClickHouseChecker.nonNull(stream, "OutputStream");
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.position > 0) {
            this.flushBuffer();
        }
        this.output.flush();
    }
}

