/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.stream.Lz4OutputStream;
import com.clickhouse.client.stream.WrappedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

public abstract class ClickHouseOutputStream
extends OutputStream {
    protected static final String ERROR_INCOMPLETE_READ = "Reached end of input stream after reading %d of %d bytes";
    protected static final String ERROR_NULL_BYTES = "Non-null byte array is required";
    protected static final String ERROR_REUSE_BUFFER = "Please pass a different byte array instead of the same internal buffer for reading";
    protected static final String ERROR_STREAM_CLOSED = "Output stream has been closed";
    protected final Runnable postCloseAction;
    protected boolean closed;

    public static ClickHouseOutputStream of(OutputStream output) {
        return ClickHouseOutputStream.of(output, (Integer)ClickHouseClientOption.WRITE_BUFFER_SIZE.getDefaultValue(), null, null);
    }

    public static ClickHouseOutputStream of(OutputStream output, int bufferSize) {
        return ClickHouseOutputStream.of(output, bufferSize, null, null);
    }

    public static ClickHouseOutputStream of(OutputStream output, int bufferSize, ClickHouseCompression compression, Runnable postCloseAction) {
        ClickHouseOutputStream chOutput;
        block6: {
            block7: {
                if (compression == null || compression == ClickHouseCompression.NONE) break block7;
                switch (compression) {
                    case GZIP: {
                        try {
                            chOutput = new WrappedOutputStream(new GZIPOutputStream(output), bufferSize, postCloseAction);
                            break block6;
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("Failed to wrap input stream", e);
                        }
                    }
                    case LZ4: {
                        chOutput = new Lz4OutputStream(output, bufferSize, postCloseAction);
                        break block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported compression algorithm: " + (Object)((Object)compression));
                    }
                }
            }
            chOutput = output instanceof ClickHouseOutputStream ? (ClickHouseOutputStream)output : new WrappedOutputStream(output, bufferSize, postCloseAction);
        }
        return chOutput;
    }

    protected ClickHouseOutputStream(Runnable postCloseAction) {
        this.postCloseAction = postCloseAction;
        this.closed = false;
    }

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(ERROR_STREAM_CLOSED);
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.writeByte((byte)(0xFF & b));
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
        }
        finally {
            this.closed = true;
            if (this.postCloseAction != null) {
                this.postCloseAction.run();
            }
        }
    }

    public abstract ClickHouseOutputStream writeByte(byte var1) throws IOException;

    public ClickHouseOutputStream writeBytes(ByteBuffer buffer, int length) throws IOException {
        byte[] bytes;
        if (buffer == null || length < 0) {
            throw new IllegalArgumentException("Non-null ByteBuffer and positive length are required");
        }
        if (buffer.hasArray()) {
            bytes = buffer.array();
        } else {
            bytes = new byte[length];
            buffer.get(bytes);
        }
        return this.writeBytes(bytes, 0, length);
    }

    public final ClickHouseOutputStream writeBytes(byte[] bytes) throws IOException {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    public abstract ClickHouseOutputStream writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public ClickHouseOutputStream writeBuffer(ClickHouseByteBuffer buffer) throws IOException {
        if (buffer == null || buffer.isEmpty()) {
            return this;
        }
        return this.writeBytes(buffer.array(), buffer.position(), buffer.length());
    }

    public abstract ClickHouseOutputStream writeCustom(ClickHouseDataUpdater var1) throws IOException;

    public ClickHouseOutputStream writeString(String value, Charset charset) throws IOException {
        if (value == null || value.isEmpty()) {
            return this.writeByte((byte)0);
        }
        byte[] bytes = value.getBytes(charset != null ? charset : StandardCharsets.UTF_8);
        int len = bytes.length;
        this.writeVarInt(len);
        return this.writeBytes(bytes, 0, len);
    }

    public ClickHouseOutputStream writeAsciiString(String value) throws IOException {
        return this.writeString(value, StandardCharsets.US_ASCII);
    }

    public ClickHouseOutputStream writeUnicodeString(String value) throws IOException {
        return this.writeString(value, StandardCharsets.UTF_8);
    }

    public ClickHouseOutputStream writeVarInt(int value) throws IOException {
        return this.writeUnsignedVarInt(value);
    }

    public ClickHouseOutputStream writeUnsignedVarInt(long value) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte b = (byte)(value & 0x7FL);
            if (value > 127L) {
                b = (byte)(b | 0x80);
            }
            this.writeByte(b);
            if ((value >>= 7) == 0L) break;
        }
        return this;
    }
}

