/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseNode;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;

public class ClickHouseException
extends Exception {
    private static final long serialVersionUID = -2417038200885554382L;
    public static final int ERROR_ABORTED = 236;
    public static final int ERROR_CANCELLED = 394;
    public static final int ERROR_NETWORK = 210;
    public static final int ERROR_POCO = 1000;
    public static final int ERROR_TIMEOUT = 159;
    public static final int ERROR_UNKNOWN = 1002;
    private final int errorCode;

    private static String buildErrorMessage(int code, Throwable cause, ClickHouseNode server) {
        return ClickHouseException.buildErrorMessage(code, cause != null ? cause.getMessage() : null, server);
    }

    private static String buildErrorMessage(int code, String message, ClickHouseNode server) {
        StringBuilder builder = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            builder.append(message);
        } else {
            builder.append("Unknown error ").append(code);
        }
        if (server != null) {
            builder.append(", server ").append(server);
        }
        return builder.toString();
    }

    private static int extractErrorCode(String errorMessage) {
        if (errorMessage == null || errorMessage.isEmpty()) {
            return 1002;
        }
        if (errorMessage.startsWith("Poco::Exception. Code: 1000, ")) {
            return 1000;
        }
        int startIndex = errorMessage.indexOf(32);
        if (startIndex >= 0) {
            int len = errorMessage.length();
            for (int i = ++startIndex; i < len; ++i) {
                char ch = errorMessage.charAt(i);
                if (ch != '.' && ch != ',' && !Character.isWhitespace(ch)) continue;
                try {
                    return Integer.parseInt(errorMessage.substring(startIndex, i));
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
        }
        return 1002;
    }

    public static ClickHouseException forCancellation(Exception e, ClickHouseNode server) {
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        return new ClickHouseException(236, cause, server);
    }

    public static ClickHouseException of(Throwable e, ClickHouseNode server) {
        Throwable cause;
        if (e instanceof ClickHouseException) {
            return (ClickHouseException)e;
        }
        Throwable throwable = cause = e != null ? e.getCause() : e;
        if (cause instanceof ClickHouseException) {
            return (ClickHouseException)cause;
        }
        if (cause == null) {
            cause = e;
        }
        ClickHouseException exp = cause instanceof SocketTimeoutException || cause instanceof TimeoutException ? new ClickHouseException(159, cause, server) : (cause instanceof ConnectException ? new ClickHouseException(210, cause, server) : new ClickHouseException(ClickHouseException.extractErrorCode(cause != null ? cause.getMessage() : null), cause, server));
        return exp;
    }

    public static ClickHouseException of(String message, ClickHouseNode server) {
        return new ClickHouseException(ClickHouseException.extractErrorCode(message), message, server);
    }

    public ClickHouseException(int code, Throwable cause, ClickHouseNode server) {
        super(ClickHouseException.buildErrorMessage(code, cause, server), cause);
        this.errorCode = code;
    }

    public ClickHouseException(int code, String message, ClickHouseNode server) {
        super(ClickHouseException.buildErrorMessage(code, message, server), null);
        this.errorCode = code;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

